/*
 *
 *	TypesIIGS.r - Wednesday, August 1, 1990
 *	Rez Resource templates for standard IIGS system types
 *
 *	Copyright Apple Computer, Inc. 1988-1990
 *	All Rights Reserved.
 *
 */



/* Resource Types */

#define	rIcon				$8001
#define rPicture			$8002
#define rControlList		$8003
#define	rControlTemplate	$8004
#define	rC1InputString		$8005
#define rPString			$8006
#define rStringList			$8007
#define rMenuBar			$8008
#define rMenu				$8009
#define rMenuItem			$800A
#define	rTextForLETextBox2	$800B
#define rCtlDefProc			$800C
#define r_BBBB				$800D
#define rWindParam1 		$800E
#define rWindParam2 		$800F
#define rWindColor			$8010
#define rTextBlock			$8011
#define rStyleBlock			$8012
#define rToolStartup		$8013
#define rResName			$8014
#define rAlertString		$8015
#define rText				$8016
#define rCodeResource		$8017
#define rCDEVCode			$8018
#define rCDEVFlags			$8019
#define rTwoRects			$801A
#define r_DDDD				$801B
#define rListRef			$801C
#define rCString			$801D
#define r_FFFF				$801E
#define r_GGGG				$801F
#define rErrorString		$8020
#define rKTransTable		$8021
#define	rWString			$8022
#define rC1OutputString		$8023
#define rSoundSample		$8024
#define rTERuler			$8025
#define rFSequence			$8026
#define rCursor				$8027
#define rItemStruct			$8028

/* Definitions and Std Ref Descriptors */

#Define NIL					0
#Define RefIsPtr			$0000
#Define RefIsHandle			$0001
#Define RefIsResource		$0002


/*********************************************************/
/* Windows
/*********************************************************/

/* Window Types */
#define fHilited			$0001
#define fZoomed				$0002
#define fAllocated			$0004
#define fCtlTie				$0008
#define fInfo				$0010
#define fVis				$0020
#define fQContent			$0040
#define fMove				$0080
#define fZoom				$0100
#define fFlex				$0200
#define fGrow				$0400
#define fBScroll			$0800
#define fRScroll			$1000
#define fAlert				$2000
#define fClose				$4000
#define fTitle				$8000

/*********************************************************/
/* Menus
/*********************************************************/

/*-------------------------------------------------------*/
/* Equates for Menu Item Flags
/*-------------------------------------------------------*/
#define rMIPlain 			$0000
#define rMIBold 			$0001
#define rMIItalic 			$0002
#define rMIUnderline 		$0004
#define rMIXOr	 			$0020
#define rMIDivider 			$0040
#define rMIDisabled 		$0080
#define rMIOutline 			$0800
#define rMIShadow 			$1000

/*-------------------------------------------------------*/
/* Equates for Menu Flags
/*-------------------------------------------------------*/
#Define rmAllowCache		$0008
#Define rmCustom			$0010
#Define rmNo_Xor			$0020
#Define rmDisabled			$0080


/* --------------------------------------------------*/
/* More flags for pop up menu controls
/* --------------------------------------------------*/
#Define fMenuDefIsText		$04

/* --------------------------------------------------*/
/* flag word for menu item
/* --------------------------------------------------*/
#Define fBold				$0001
#Define fItalic				$0002
#Define fUnderline			$0004
#Define fXOR				$0020
#Define fDivider			$0040
#Define fDisabled			$0080
#Define fOutline			$0800
#Define fShadow				$1000
#Define ItemTitleRefShift	$4000

/* --------------------------------------------------*/
/* flag word for Menu
/* --------------------------------------------------*/
#Define fAllowCache			$0008
#Define fCustom				$0010
#Define ItemRefShift		$1000
#Define MenuTitleRefShift	$4000

/* --------------------------------------------------*/
/* flag word for Menu bar
/* --------------------------------------------------*/
#Define MenuRefShift		$4000


/*********************************************************/
/* Controls
/*********************************************************/

/*-------------------------------------------------------*/
/* Control List Descriptors
/*-------------------------------------------------------*/
#define singlePtr			$0000
#define singleHandle		$0001
#define singleResource		$0002
#define ptrToPtr			$0003
#define ptrToHandle			$0004
#define ptrToResource		$0005
#define handleToPtr			$0006
#define handleToHandle		$0007
#define handleToResource	$0008
#define ResourceToResource	$0009

/*-------------------------------------------------------*/
/* Common Flag equates.
/*-------------------------------------------------------*/
#define ctlInvis			$0080
#define ctlVisible			$0000
#Define CtlInactive			$FF00


/*-------------------------------------------------------*/
/* Common MoreFlags equates.
/*-------------------------------------------------------*/
#define FctlTarget			$8000
#define FctlCanBeTarget		$4000
#define FctlWantsEvents		$2000
#define FctlProcNotPtr		$1000
#define FctlTellAboutSize	$0800
#define FctlIsMultiPart		$0400


/*-------------------------------------------------------*/
/* Flag Equates for StatText Controls
/*-------------------------------------------------------*/
#Define fSubstituteText		$0002
#Define fSubTextIsPascal	$0001
#Define fSubTextIsC			$0000


/*-------------------------------------------------------*/
/* Flag equates for simple buttons.
/*-------------------------------------------------------*/
#Define NormalButton		$0000
#Define DefaultButton		$0001
#Define SquareButton		$0002
#Define SquareShadowButton	$0003

/* --------------------------------------------------*/
/* TextFlags Equates for TextEdit Control
/* --------------------------------------------------*/
#Define fNotControl				$80000000
#Define fSingleFormat			$40000000
#Define fSingleStyle			$20000000
#Define fNoWordWrap				$10000000
#Define fNoScroll				$08000000
#Define fReadOnly				$04000000
#Define fSmartCutPaste			$02000000
#Define	fTabSwitch				$01000000
#Define fDrawBounds				$00800000
#Define fColorHilight			$00400000
#Define fGrowRuler				$00200000
#Define fDisableSelection		$00100000
#Define fDrawInactiveSelection	$00080000


/* --------------------------------------------------*/
/* Text Descriptors for TextEdit Controls
/* --------------------------------------------------*/
#Define dataIsPString		$0000
#Define dataIsCString		$0001
#Define dataIsC1Input		$0002
#Define dataIsC1Output		$0003
#Define dataIsTextBox2		$0004
#Define dataIsTextBlock		$0005

/* --------------------------------------------------*/
/* Flag equates  for PopUp Menu Controls
/* --------------------------------------------------*/
#Define fType2PopUp			$40
#Define fDontHiliteTitle	$20
#Define fDontDrawTitle		$10
#Define fDontDrawResult		$08
#Define fInWindowOnly		$04
#Define fRightJustifyTitle	$02
#Define fRightJustifyResult	$01


/*********************************************************/
/* LineEdit
/*********************************************************/

/*---------------------- LETextBox2 styles -------------*/
#Define TBStylePlain		"\$01S\$00\$00"	/* $01 $53 $00 $00 */
#Define TBStyleBold			"\$01S\$01\$00"	/* $01 $53 $00 $00 */
#Define TBStyleItalic		"\$01S\$02\$00"	/* $01 $53 $00 $00 */
#Define TBStyleUnderline	"\$01S\$04\$00"	/* $01 $53 $00 $00 */
#Define TBStyleOutline		"\$01S\$08\$00"	/* $01 $53 $00 $00 */
#Define TBStyleShadow		"\$01S\$10\$00"	/* $01 $53 $00 $00 */
#Define TBStyleHEX			"\$01S"
#Define TBForeColor			"\$01C"
#Define TBBackColor			"\$01B"
#Define TBColor0			"\$00\$00"
#Define TBColor1			"\$11\$11"
#Define TBColor2			"\$22\$22"
#Define TBColor3			"\$33\$33"
#Define TBColor4			"\$44\$44"
#Define TBColor5			"\$55\$55"
#Define TBColor6			"\$66\$66"
#Define TBColor7			"\$77\$77"
#Define TBColor8			"\$88\$88"
#Define TBColor9			"\$99\$99"
#Define TBColorA			"\$AA\$AA"
#Define TBColorB			"\$BB\$BB"
#Define TBColorC			"\$CC\$CC"
#Define TBColorD			"\$DD\$DD"
#Define TBColorE			"\$EE\$EE"
#Define TBColorF			"\$FF\$FF"
#Define TBLeftJust			"\$01J\$00\$00"
#Define TBCenterJust		"\$01J\$01\$00"
#Define TBRightJust			"\$01J\$FF\$FF"
#Define TBFillJust			"\$01J\$02\$00"
#Define TBLeftMargin		"\$01L"
#Define TBRightMargin		"\$01M"
#Define TBSpExtra			"\$01X"
#Define TBEndOfLine			"\n"
#Define TBFont				"\$01F"
#Define TBShaston			"\$FE\$FF"
#Define TBNewYork			"\$02\$00"
#Define TBGeneva			"\$03\$00"
#Define TBVenice			"\$05\$00"
#Define TBTimes				"\$14\$00"
#Define TBHelvetica			"\$15\$00"
#Define TBCourier			"\$16\$00"


/*********************************************************/
/* CDEVs
/*********************************************************/

/*----------- Definitions for CDEVFlags word -----------*/

#define wantReserved0		$0001
#define wantBoot			$0002
#define wantShutDown		$0004
#define wantInit			$0008
#define wantClose			$0010
#define wantEvents			$0020
#define wantCreate			$0040
#define wantAbout			$0080
#define wantRect			$0100
#define wantHit				$0200
#define wantRun				$0400
#define wantReserved1		$0800
#define wantReserved2		$1000
#define wantReserved3		$2000
#define updateSSfromBRAM	$4000
#define CanBeInActive		$8000

#define word integer


/*********************************************************/
/* The Resource Definitions.
/*********************************************************/

/*---------------------- rWindColor --------------------*/
type rWindColor {
		unsigned hex word;			/* frameColor */
		unsigned hex word;			/* titleColor */
		unsigned hex word;			/* tbarColor */
		unsigned hex word;			/* growColor */
		unsigned hex word;			/* infoColor */
};

/*---------------------- rPString ----------------------*/
type rPString {
		pstring;					/* String */
};

/*---------------------- rCString ----------------------*/
type rCString {
		cstring;					/* String */
};

/*---------------------- rC1InputString ----------------------*/
type rC1InputString {
		wstring;					/* String */
};

/*--------------------- rC1OutputString ----------------*/
type rC1OutputString {
		unsigned hex word;			/* buffer length */
		wstring;
};

/*---------------------- rWString ----------------------*/
type rWString {
		wstring;					/* String */
};

/*---------------------- rStringList -------------------*/
type rStringList {
		integer = $$Countof(StringArray);
		array StringArray {
				pstring;			/* String */
		};
};

/*---------------------- rResName ----------------------*/
type rResName {
	integer;					/* name holder format */
	longint = $$Countof(NAMES);	/* name count */
		array NAMES {
			longint;			/* ID of the resource */
			pstring;			/* Name of the resource */
		};
};

/*---------------------- rCDEVCode ---------------------*/
type rCDEVCode {
		wide array {
			byte; 
			};
};

/*--------------------- rCodeResource ------------------*/
type rCodeResource {
		wide array {
				byte;
				};
};

/*---------------------- rCtlDefProc -------------------*/
type rCtlDefProc {
		wide array {
			hex byte;
			};
};

/*---------------------- rControlList ------------------*/
type rControlList {
		array {
			longint;
			};
		longint = 0;
};

/*------------------------ rText ----------------------*/
type rText {
		string;
};

/*--------------------- rTextBlock --------------------*/
type rTextBlock {
		string;
};

/*------------------------ rTextForLETextBox2 ---------*/
type rTextForLETextBox2 {
		string;
};

/*----------------------- rAlertString ----------------*/
type rAlertString {
		string;
};

/*----------------------- rErrorString ----------------*/
type rErrorString {
		string;
};

/*-------------------- rWindParam1 --------------------*/
type rWindParam1 {
		integer	= $50;				/*length of parameter list, should be $50*/
		integer;					/* wFrameBits */
		longint;					/* wTitle */
		longint;					/* wRefCon */
		rect;						/* ZoomRect	*/
		longint;					/* wColor ID */
		point;						/* Origin */
		point;						/* data size */
		point;						/* max height-width */
		point;						/* scroll ver hors */
		point;						/* page vers horiz */
		longint;					/* winfoRefcon */
		integer;					/* wInfoHeight */
		fill long[3];				/* wFrameDefProc,wInfoDefProc,wContDefProc */
		rect;						/* wposition */
		longint behind=0,infront=-1;/* wPlane */
		longint;					/* wStorage */
		integer;					/* wInVerb */
};

/*---------------------- rWindParam2 ---------------------*/
type rWindParam2 {
		integer;					/* param id */
		unsigned longint = nil;		/* nil */
		wide array {
			hex byte;		/* fedined by window def proc */
			};
};

/*---------------------- rSoundSample --------------------*/
type rSoundSample {
		integer;					/* format */
		integer;					/* wave size */
		integer;					/* rel pitch */
		integer;					/* flags */
		integer;					/* sample rate */
		wide array {
		    hex byte;				/* raw 8 bit sound data */
			};
};

/*---------------------- rFSequence --------------------*/
type rFSequence {
		integer;					/* format */
		integer;					/* tempo */
		integer;					/* Tracks Used (0-14) */
		integer = $$Countof(Tracks);
		wide array Tracks {
			longint;
			};
		wide array {
		    longint;				/* 4 byte sequence items */
			};
};

/*---------------------- rCursor ----------------------*/
type rCursor {
		integer;					/* height */
		integer;					/* width  */
		wide array {				/* image  */
			hex integer;
			};
		wide array {				/* mask	  */
			hex integer;
			};
		integer;					/* HotY		*/
		integer;					/* HotX		*/
		integer;					/* Cursor ID */
		longint = 0;				/* filler */
		longint = 0;				/* filler */
};
			
/*---------------------- rTERuler --------------------*/
type rTERuler {
		integer;					/* left margin */
		integer;					/* left indent */
		integer;					/* right margin */
		integer;					/* just */
		integer;					/* extra line spacing */
		integer;					/* flags */
		longint;					/* user data */
		integer;					/* tab type */
		integer = $$Countof(TabArray);
		wide array TabArray {
		    integer;				/* the pixels positions for the tabs */
			};
};

/*------------------------ rTwoRect ----------------------*/
type rTwoRects {
		rect;						/* rect 1 */
		rect;						/* rect 2 */
};

/*----------------------- rCDEVFlags ---------------------*/
type rCDEVFlags {
		unsigned word;				/* flags word */
		byte;						/* enabled */
		byte;						/* version */
		byte;						/* machine */
		byte;						/* reserved */
		rect;						/* data rectangle */
		pstring[15];				/* CDEV name */
		pstring[32];				/* author name */
		pstring[8];					/* version name */
};


/*-------------------------- rIcon -----------------------*/
type rIcon {
		hex integer;				/* Icon Type bit 15  1 = color, 0 = mono */
image:
		integer	= (Mask-Image)/8 - 6;/* size of icon data in bytes */
		integer;					/* height of icon in pixels */
		integer;					/* width of icon in pixels */
		hex string [$$Word(image)];	/* icon image */
mask:
		hex string;					/* icon mask */
};



/* ----------------------- rMenuBar -------------------------*/
type rMenuBar {
	integer = 0;					/* version must be zero */
	integer = 0x8000;				/* the following refs are all menu resID's */
	array {
		longint;					/* menu template ID list */
		};
	longint = 0;
};

/*------------------------ rMenu ----------------------------*/
type rMenu {
	integer = 0;					/* version must be zero */
	integer;						/* menu ID */
	integer;						/* flags */
	longint;						/* menu title ref */
	array {
		longint;					/* menu item list */
		};
	longint = 0;					/* terminating item type */
};

/*------------------------ rMenuItem -----------------------*/
type rMenuItem {
	integer = 0;					/* version must be zero */
	integer; 						/* item ID */
	char;							/* item char */
	char;							/* alt char */
	integer;						/* item check */
	integer;						/* flags */
	longint;						/* item titleref */
};

/*---------------------- rToolStartup ---------------------*/
type rToolStartup {
	integer = 0;						/* flags must be zero */
	Integer mode320 = 0,mode640 = $80;	/* mode to start quickdraw */
	Integer = 0;
	Longint = 0;
	integer = $$Countof(TOOLRECS);		/* number of tools */
		array TOOLRECS {
			Integer;					/* ToolNumber */
			Integer;					/* version */
		};
};


/*------------------------ rListRef -----------------------*/
type rListRef {
	Array {
			longint;							/* Item Ref */
			bitstring[6] memSelected = 0x20,	/*ItemFlags*/
						 memDisabled = 0x10,
						 memNormal = 0;
			bitstring[2] = 2;
		   };
};
#define KeyEquiv  array[1]{ char; char; word; word; }
/*------------------------ rControlTemplate ---------------*/
type rControlTemplate {
		integer = 3+$$optionalcount (Fields);/* pCount must be at least 6 */
		longint;							/* Application defined ID */
		rect;								/* controls bounding rectangle */
		switch {
		
		case SimpleButtonControl:
			key longint = 0x80000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				longint;					/* Title Ref */
				longint;					/* color table ref */
				KeyEquiv;
			};

		case CheckControl:
			key longint = 0x82000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				longint;					/* Title Ref */
				integer;					/* initial value */
				longint;					/* color table ref */
				KeyEquiv;
			};
					
		case RadioControl:
				key longint = 0x84000000;	/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				longint;					/* Title Ref */
				integer;					/* initial value */
				longint;					/* color table ref */
				KeyEquiv;
			};	
		case scrollControl:
			key longint = 0x86000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				integer;					/* Max Size */
				integer;					/* viewSize */
				integer;					/* initial value */
				longint;					/* color table ref */
			};
			
		case statTextControl:
			key longint = 0x81000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				longint;					/* Text Ref */
				integer;					/* text size */
				integer;					/* text justification */
			};
					
		case editLineControl:
			key longint = 0x83000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				integer;					/* Max Size */
				longint;					/* resource ID of the text */
			};
										
		case PopUpControl:
			key longint = 0x87000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				integer;					/* Title Width */
				longint;					/* menu Ref */
				integer;					/* Initial Value */
				longint;					/* Color table ref */
			};
					
		case ListControl:
			key longint = 0x89000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				integer;					/* list size */
				integer; 					/* List View */
				integer;					/* List Type */
				integer;					/* List Start */
				longint =0 ;				/* member drawing routine */
				integer;					/* ListMemHeight */
				integer;					/* List Mem Size */
				longint;					/* List Ref */
				longint;					/* Color Ref */
			};
					
		case growControl:
			key longint = 0x88000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				longint;					/* color table ref */
			};

		case PictureControl:
			key longint = 0x8D000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				longint;					/* picture ref */
			};

		case editTextControl:
			key longint = 0x85000000;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				longint;					/* text flags */
				rect;						/* indent rect */
				longint;					/* vert bar */
				integer;					/* vert Amount */
				longint;					/* hor bar */
				integer;					/* hor amount */
				longint;					/* style ref */
				integer;					/* text descriptor */
				longint;					/* text ref */
				longint;					/* text length */
				longint;					/* max chars */
				longint;					/* max lines */
				integer;					/* Max chars per line */
				integer;					/* max height */
				longint;					/* color ref */
				integer;					/* drawing mode */
				LongInt;					/* Filter Proc Ptr */
			};
										
		case IconButtonControl:
			key longint = 0x07FF0001;		/* procRef */
			optional Fields {
				integer;					/* flags */
				integer;					/* more flags */
				longint;					/* refcon */
				longint;					/* Icon Ref */
				longint;					/* Title Ref */
				longint;					/* color table ref */
				integer;					/* Display mode */
				KeyEquiv;
			};
					

		};
};


/*----------------------- rStyleBlock ----------------------*/
type rStyleBlock {
	integer = 0;					/* version number */
 	switch {
	   case NoTabRuler:
		   longint = 18;   			/* size of ruler record */
		   integer;					/* leftMargin */
		   integer;					/* leftIndent */
		   integer;					/* rightMargin */
		   integer leftJust,
		   centerJust,
		   fullJust,
		   rightJust = -1; 			/* just */
		   integer;					/* extraLS */
		   hex integer;				/* flags */
		   hex longint;				/* userData */
		   key integer = 0;
	 
	   case RegularTabRuler:
		   longint = 20;   			/* size of ruler record */
		   integer;					/* leftMargin */
		   integer;					/* leftIndent */
		   integer;					/* rightMargin */
		   integer leftJust,
		   centerJust,
		   fullJust,
		   rightJust = -1; 			/* just */
		   integer;					/* extraLS */
		   hex integer;				/* flags */
		   hex longint;				/* userData */
		   key integer = 1;
		   integer;					/* tab interval */
	 
	   case AbsoluteTabRuler:
			longint = 20+4*$$Countof(TabStops); /* size of ruler record */
			integer;				/* leftMargin */
			integer;				/* leftIndent */
			integer;				/* rightMargin */
			integer leftJust,
			centerJust,
			fullJust,
			rightJust = -1; 		/* just */
			integer;				/* extraLS */
			hex integer;			/* flags */
			hex longint;			/* userData */
			key integer = 2;
			wide array TabStops {
			   integer = 0;			/* tabKind */
			   integer;				/* absolute tab stop */
			};
			integer = $ffff;    	/* tab stop array terminator */
	};
 
	longint = $$Countof(StyleLists)*12; /* size of StyleLists array */
	wide array StyleLists {
		hex longint
		courier10   = $0A000016,
		courier12   = $0C000016,
		geneva10	= $0A000003,
		geneva12	= $0C000003,
		venice14	= $0E000005,
		shaston8	= $0800fffe,
		shaston16   = $1000fffe;	/* fontID */

		hex integer
		black		= $0000,
		blue    	= $1111,
		olive   	= $2222,
		gray1   	= $3333,
		red 		= $4444,
		purple  	= $5555,
		orange  	= $6666,
		salmon  	= $7777,
		green   	= $8888,
		turquoise   = $9999,
		brightGreen = $aaaa,
		dullGreen   = $bbbb,
		gray2   	= $cccc,
		lightBlue   = $dddd,
		yellow  	= $eeee,
		white   	= $ffff;
									/* foreColor */
		hex integer
		black   	= $0000,
		blue    	= $1111,
		olive   	= $2222,
		gray1   	= $3333,
		red			= $4444,
		purple  	= $5555,
		orange  	= $6666,
		salmon  	= $7777,
		green   	= $8888,
		turquoise   = $9999,
		brightGreen = $aaaa,
		dullGreen   = $bbbb,
		gray2   	= $cccc,
		lightBlue   = $dddd,
		yellow  	= $eeee,
		white   	= $ffff;
									/* backColor */
		hex longint;				/* userData */
	};
 
   longint = $$Countof(StyleItems);	/* number of StyleItem records */
   wide array StyleItems {
	   longint;						/* length of style run */
	   longint;						/* offset into StyleLists array */
   };
};
